/*
 * Note for teachers:
 * 
 * Below is one possible way you could use this lab with students. Depending on how
 * much you do/don't want them to do on their own, you can add back in code from the
 * solution files or you can delete more code from this lab before you hand it out.
 * The philosophy taken here is to have them working mainly with the World, Grid, and 
 * Location classes - therefore, the code that takes care of the structure of the game,
 * graphics, etc. has been left intact. 
 * 
 * Directions for students:
 * 
 * If a method contains "*** complete this method ***" on the first line, complete
 * it where the comments direct you. Otherwise, the methods are already complete.
 */

/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import info.gridworld.grid.Grid;
import info.gridworld.grid.BoundedGrid;
import info.gridworld.grid.Location;
import info.gridworld.world.World;

import java.util.ArrayList;
import java.util.Scanner;
import java.util.Stack;

import java.awt.Color;

import java.io.File;
import java.io.FileNotFoundException;

/**
 * A <code>MazeWorld</code> is the mediator between a grid and the GridWorld GUI.
 * This class is also the main application.
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p>
 * Use this class to teach students about recursion/stacks. In addition,
 * file I/O can be taught using Java 5's new Scanner class.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class MazeWorld extends StepWorld<Tile>
{
   private Location startingLoc = null;

   /**
     * Constructs a MazeWorld object
     */   
   public MazeWorld()
   {
      makeMaze();
      setMessage("Click starting Location - press Step/Run when ready");
   }
   
   /**
     * Makes the maze by reading a text file
     */
   private void makeMaze() {
	   *** complete this method ***
       
	   Scanner dataFile = null;
       int rows;
              
       try { 
         dataFile = new Scanner( new File("mazeData.txt") );
       }
       catch (FileNotFoundException ex) 
       {
         System.out.println("** Can't find the file **");
         System.exit(1);
       }

       rows = dataFile.nextInt();
       dataFile.nextLine();  // dump rest of data on line
       setGrid(new BoundedGrid<Tile>(rows,rows));
       
       /*
        * write a nested for loop here which reads one line at a time
        * and then within each line takes one character at a time and
        * checks to see if it is an "x" - if it is, put a black tile
        * in the world at the proper location using the add() method
        */
       
       dataFile.close();
   }

   /**
     * This method is called from the GUI when the user presses the Step or Run button.
     */   
   public void run()
   {
      if ( startingLoc == null ) 
      {
        setMessage("You haven't chosen the starting location yet");
        return;
      }
      if ( escape(startingLoc) )
        setMessage("ESCAPED");
      else
        setMessage("TRAPPED");
   }

   /**
     * Returns whether or not the given location is located at the edge of the Grid
     * <br>precondition: <code>loc</code> is a valid location in the Grid
     * @param loc a valid location in the Grid
     * @param gridRow the number of rows in the Grid
     * @param gridCol the number of columns in the Grid
     * @return <code>true</code> if <code>loc</code> located on the outer border of the Grid,
     * otherwise, returns <code>false</code>
     */   
   private boolean onBorder(Location loc, int gridRow, int gridCol) 
   {
	   *** complete this method ***
   }
   
   /**
     * Method attempts to find a path out of the maze
     * <br>precondition: <code>loc</code> is a valid location in the Grid
     * @param loc a valid location in the Grid
     * @return <code>true</code> if there is a path that leads to the edge of the Grid,
     * otherwise returns <code>false</code>
     */   
   private boolean escape(Location loc) {
	   *** complete this method ***
	   
       // Recursive Version - outlined for you - complete it
       Grid<Tile> gr = ...
       ArrayList<Location> nbrs = ...
       for (Location aLoc: nbrs) {
          if ( ... ) // check if on border, if yes, then escaped
          {
             ... // add a red tile with "escaped" as text to the world and return true
          }
          else { // not on border, so add a red tile to show the location has been visited
             ... // add a red tile to the world
          }
          pause("searching...");
          ... // make a recursive call and if it returns with true, return true
       }
       return false;
       // End of Recursive Version
       
       /*
        * Note: For AB students, you can write this method either recursively as
        * outlined above - or write it using a Stack.
        */ 
   }
   
   /**
     * Method called from the GUI and passed a valid Grid location
     * <br>precondition: <code>loc</code> is a valid location in the Grid
     * @param loc a valid location in the Grid
     * @return <code>true</code> if you want the GUI to consume the click,
     * otherwise <code>false</code> to have the GUI resume its default function of
     * showing the constructor methods if its an empty cell or the methods of the object
     * at an occupied location
     */   
   public boolean locationClicked(Location loc)
   {
     if ( startingLoc == null && getGrid().get(loc) == null ) 
     { 
       startingLoc = loc;
       add(loc, new Tile("start", Color.YELLOW));
       setMessage(loc + " is the starting location. Click Step or Run");
     }
     else 
       if ( startingLoc == null )
         setMessage("That location is an invalid starting location - choose another");
     return true;      
   }
   
   public static void main(String[] args)
   {
     World mw = new MazeWorld();
     System.setProperty("info.gridworld.gui.selection", "hide");
     mw.show();
   }
}
