/*
 * Note for teachers:
 * 
 * Below is one possible way you could use this lab with students. Depending on how
 * much you do/don't want them to do on their own, you can add back in code from the
 * solution files or you can delete more code from this lab before you hand it out.
 * The philosophy taken here is to have them working mainly with the World, Grid, and 
 * Location classes - therefore, the code that takes care of the structure of the game,
 * graphics, etc. has been left intact. 
 * 
 * Directions for students:
 * 
 * If a method contains "*** complete this method ***" on the first line, complete
 * it where the comments direct you. Otherwise, the methods are already complete.
 */

/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import info.gridworld.world.World;
import info.gridworld.grid.Grid;
import info.gridworld.grid.BoundedGrid;
import info.gridworld.grid.Location;

/**
 * The <code>WuZiQiGameRunner</code> is the main application. 
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class WuZiQiGameRunner extends World<GamePiece>
{
    private boolean isBlacksTurn;
    private boolean winner;

    /**
     * Construct a WuZiQi Game
     */
    public WuZiQiGameRunner() 
    {
      isBlacksTurn = true;
      winner = false;
      makeBoard();
      setMessage("WuZiQi(Gomoku) - Black Goes First");
    }

    /**
     * Initialize the board. It is initially just filled with all gray background
     * tiles (GamePiece.gif) so the board is beautiful.
     *
     */
    private void makeBoard() 
    {
   	  *** complete this method ***
   	  
   	  /*
   	   * Students, do the following:
   	   * 1) call setGrid and pass it a bounded, 9-by-9 grid one which can hold GamePiece objects
   	   * 2) write a nested for loop which traverses through all locations in the grid and places
   	   * a new GamePiece representing a background tile (look at the GamePiece class to see how
   	   * to construct a piece which represents a background tile).
   	   */
   	  ...
    }
    
    /**
     * Determines the winner. 
     * @param loc loacation of the last piece just played
     * @return <code>true</code> if the piece just played at position <code>loc</code> completes
     * a win for the player who just moved, false if no such winner yet
     */
    private boolean determineWinner(Location loc) {
      // only need to check if 5 in a row from the current loc (last move made)
      int dir = Location.AHEAD, consecutive = 0;
      Location nextLoc;
      Grid<GamePiece> gr = getGrid();
      
      /*
       * Students: There are 4 main axes from the current loc to check for 5-in-a-row.
       * To help you write this you should first look at the constants within the Location
       * class to see what is available to you. You will find Location.HALF_CIRCLE and
       * Location.HALF_RIGHT of possible use. Essentially, for each of the 4 exes (the vertical,
       * the horizontal, the major diagonal and the minor diagonal) you need to keep count of the
       * number of consecutive pieces that match the piece played at location loc - you can, for example,
       * go up from the current loc until you either run off the board or you get to a piece that
       * doesn't match the one played, keeping count of the consecutive ones while you go upward - then,
       * go downward adding on to your consecutive count. That will take care of the vertical axis. 
       * You can check at that point whether your count is >= 5 and, if so, return true. Otherwise, 
       * check the other 3 axes in a similar manner.
       */
    }
    
    /**
     * When the current player clicks and attempts to place a piece, this method
     * see whether it is a legal move and, if so, places a piece and calls determineWinner
     * @param loc location passed from the GUI where the use just clicked
     */
    public boolean locationClicked(Location loc)
    {
      if ( winner )
        return true; 
      if ( getGrid().get(loc).isBackground() ) // player making a legal move
      {
        if ( isBlacksTurn ) 
        {
          add(loc, new GamePiece("_black"));
          setMessage("White's Turn - Black moved to " + loc);
        }
        else
        {
          add(loc, new GamePiece("_white"));
          setMessage("Black's Turn - White moved to " + loc);
        }
        if ( determineWinner(loc) ) 
        {
          winner = true;
          if ( isBlacksTurn )
            setMessage("Black WINS");
          else
            setMessage("White WINS");
        }
        isBlacksTurn = !isBlacksTurn;
      }
      else // player making an illegal move
      {
        if ( isBlacksTurn )
          setMessage("Occupied Cell - Black, it's still your turn");
        else
          setMessage("Occupied Cell - White, it's still your turn");
      }
      return true;      
    }
   
    public static void main(String[] args)
    {
      World wzq = new WuZiQiGameRunner();
      System.setProperty("info.gridworld.gui.selection", "hide"); // get rid of focus indicator on the gui
      wzq.show();
    }
}