/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

/*
 * note on images/graphics/text: 
 * 
 * GridWorld works very simply. If you have a .gif file with the 
 * same name as this class (GamePiece.gif), then that graphic
 * will get displayed. If there is no .gif, then the gui will look
 * for a getColor() and getText() method in this class. If it finds
 * one or the other, the cell will be displayed in that color with 
 * that text.
 * 
 * Swapping images, as I'm doing here below, is also easily accomplished.
 * In this lab I need a black piece, a white piece, and a gray tile(so that
 * my board looks beautiful and each cell blends together(my "empty" cells
 * will contain a gray tile). So, I have 3 graphic files, 
 * GamePiece.gif(gray tile), GamePiece_black.gif, and GamePiece_white.gif.
 * If I want the GUI to swap a different image but keep this same class, just
 * provide a getImageSuffix() method which returns the suffix ("", "_black",
 * or "_white"). It'll then find the correct graphic in your project. Cool!
 * 
 * Lastly, if a class has no graphic, no getColor() and no getText() method,
 * then the GUI will simply call the toString() method. That's awesome. That 
 * means that putting Integer, String, Boolean, etc. objects into the World 
 * will have their toString() values automagically displayed with no extra effort.
*/

/**
 * A <code>GamePiece</code> the game piece that is placed in the Grid. It
 * will represent either a black game piece, white game piece, or, if it's
 * being used to represent the background of the game board, then it will be
 * a gray piece.
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class GamePiece
{
    private String blackOrWhiteImageSuffix = "";

    /**
     * Construct a game piece
     * @param blackOrWhiteImageSuffix a String representing whether this game piece should be 
     * a black("_black") piece, a white("_white") piece, or gray background piece("")
     */    
    public GamePiece(String blackOrWhiteImageSuffix) 
    {
      this.blackOrWhiteImageSuffix = blackOrWhiteImageSuffix; 
    }
    
    /**
     * Called by the GridWorld GUI to get the image suffix - it will then find the proper .gif file
     */
    public String getImageSuffix() 
    { 
      return blackOrWhiteImageSuffix; 
    }

    public boolean equals(Object obj) 
    {
      GamePiece other = (GamePiece)obj;
      return blackOrWhiteImageSuffix.equals(other.blackOrWhiteImageSuffix);
    }

    /**
     * Gets whether or not this piece is being used as an "empty" background cell for the gui
     * @return <code>true</code> if piece is being used as an "empty" background cell for the gui, 
     * <code>false</code> otherwise
     */    
    public boolean isBackground() 
    { 
      return "".equals(blackOrWhiteImageSuffix); 
    }
    
    public String toString() 
    { 
      return blackOrWhiteImageSuffix; 
    }
}