/*
 * Note for teachers:
 * 
 * Below is one possible way you could use this lab with students. Depending on how
 * much you do/don't want them to do on their own, you can add back in code from the
 * solution files or you can delete more code from this lab before you hand it out.
 * The philosophy taken here is to have them working mainly with the World, Grid, and 
 * Location classes - therefore, the code that takes care of the structure of the game,
 * graphics, etc. has been left intact. 
 * 
 * Directions for students:
 * 
 * If a method contains "*** complete this method ***" on the first line, complete
 * it where the comments direct you. Otherwise, the methods are already complete.
 */

/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.world.World;

import java.awt.Color;
import java.util.ArrayList;
/**
 * The <code>MagicWandWorld</code> is the main application. 
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class MagicWandWorld extends World<Tile>
{
   private Location startingLoc = null;
   private Color startingColor = null;

   /**
     * Constructs a MagicWand World
     */      
   public MagicWandWorld()
   {
     makeWorld();
     setMessage("Your Magic Wand is now the eye dropper - \"Pick Up\" a color by clicking a cell");
   }

   /**
     * Ramdomly place Tiles in the world
     */      
   private void makeWorld()
   {
	 *** complete this method ***
	 
     Grid<Tile> gr = getGrid();
     Color[] colors = { Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW };
 
     /* 
      * Write a nested for loop going through all rows and columns
      * of the grid and inserting a new Tile made from a random color 
      * choice from the colors vector above. To get a random color, 
      * use Math.random() to help you get a random integer from 0..4 - 
      * then use that to select the color from the array.
      */
     ...
   }
   
   /**
    * This is the recursive method which does the changing of the colors. It is called from locationClicked().
    * @param loc location of the candidate cell for a color change
    * @param col color of the cell at location <code>loc</code>
    */
   private void changeColors(Location loc, Color col)
   {
	 *** complete this method ***  
	      
     // Recursive Version
	 /*
	  * Students, do the following:
	  * 1) see if the color of the object at location loc in the grid matches col - if not, return
	  * 2) put a new Tile into the grid at location loc which has the startingColor as its color
	  * 3) get all the occupied locations around loc within the grid and, for each one, call changeColors
	  */   
     // End of Recursive Version
        
     // Stack version - AB students only
	 /*
	  * Students, if you haven't written the recursive version yet, take a few minutes to
	  * do so - for an AB student, this should be relatively quick. Then, once that works,
	  * comment it out and write a new version which uses a Stack instead. 
	  */
     // End of Stack Version
   }
   
   /**
    * This method is auto-magically called by the GUI and passed the 
    * location that the user clicked.
    * @param loc location on the Grid where the mouse was clicked
    * @return <code>true</code> if the world consumes the key press, <code>false</code>
    * @see <code>World</code> class
    */
   public boolean locationClicked(Location loc)
   {
       Grid<Tile> gr = getGrid();
       if ( startingLoc == null )
       {
         startingLoc = loc;
         startingColor = gr.get(loc).getColor();
         setMessage("You now have a magic wand, try it!\nYour magic color is " + startingColor);
       }
       else 
         if ( ! gr.get(loc).getColor().equals(startingColor) ) 
           changeColors(loc, gr.get(loc).getColor());
       return true;      
   }
    
   public static void main(String[] args)
   {
     World mw = new MagicWandWorld();
     System.setProperty("info.gridworld.gui.selection", "hide");
     mw.show();
   }
}