/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import java.awt.*;
import javax.swing.*;
/**
 * A <code>TimerFrame</code> is used to keep time in a separate 
 * frame and thread.
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class TimerFrame extends JFrame 
{
	private Counter c;
	private static final long serialVersionUID = 42L; // required to rid this code of a warning, see Serializable for explanation

	public TimerFrame() 
	{
	  setSize(270,70);
	  setTitle("TrafficJam - Game Time");
	  setVisible(true);
	}
	
	public void startTime() 
	{
	  c = new Counter(getGraphics(), getHeight(), getWidth());
	  c.start();
	}
	
	public void stopTime() 
	{
	  c.kill();
	}
}

class Counter extends Thread 
{				
	private long startTime;
	private Graphics myG;
	private int frameHeight, frameWidth;
	private boolean iAmAlive;
	
	public Counter(Graphics g, int frameHeight, int frameWidth) 
	{
	  this.frameHeight = frameHeight;
	  this.frameWidth = frameWidth;
	  myG = g;
	  iAmAlive = false;
	  myG.setFont(new Font("Courier",Font.BOLD, 14));
	  myG.setColor(Color.RED);
	  startTime = System.currentTimeMillis();
	}
	
	public void kill() 
	{
	  iAmAlive = false;
	}
	
	public void run() 
	{	
	  String s = new String();	
	  iAmAlive = true;
	  Long current=0L, min=0L, sec=0L;
	  while ( iAmAlive )
	  {
	    current = System.currentTimeMillis();
	    min = (current-startTime)/1000/60;
	    sec = (current-startTime)/1000%60;
		s = "Elapsed Time -- min:" + min + " sec:" + sec;
		myG.clearRect(0, 0, frameWidth, frameHeight);
		myG.drawString(s, 10, frameHeight-20);
		try 
		{
		  sleep(1000); 
		}
		catch (InterruptedException e) 
		{
		  System.out.println("sleep exception");
		}
	  }
	  s = "You Win -- min:" + min + " sec:" + sec;
	  myG.clearRect(0, 0, frameWidth, frameHeight);
	  myG.drawString(s, 10, frameHeight-20);
	}
}