/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import java.awt.Color;
import info.gridworld.grid.Location;
/**
 * A <code>Piece</code> is the basic unit which makes up the Block.
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class Piece
{
    private String imgSuffix = "";
    private int dir;
    private Color col;
    private Location loc;
    
    /**
     * Construct a Piece
     * @param imgSuffix there are 2 kinds of images that will be displayed to make up 
     * the arrows in the game. If "" is used, that signifies to load Piece.gif which is
     * a main body segment of an arrow (just a rectangluar shaped image). If "_arrow" is
     * used, that signifies to load Piece_arrow.gif, which is an arrow tip.
     * @param dir direction the piece is facing (0, 90, 180, 270)
     * @param col color of the piece
     * @param loc location of the piece for placement into the Grid
     */
    public Piece(String imgSuffix, int dir, Color col, Location loc) 
    {
      this.imgSuffix = imgSuffix; 
      this.dir = dir;
      this.col = col;
      this.loc = loc;
    }
    
    // these are auto-magically called by gui to get
    // the piece displayed nicely - soooooo COOL
    public Location getLocation() 
    {
      return loc;
    }
    
    public int getDirection() 
    { 
      return dir;
    }
    
    public String getImageSuffix() 
    { 
      return imgSuffix; 
    }
    
    public Color getColor() 
    { 
      return col; 
    }
    
    public String toString() 
    {
      return "a piece of the arrow";
    }
}