/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import java.awt.Color;
import info.gridworld.grid.Location;
/**
 * A <code>Block</code> describes a single game piece that occupies several
 * grid locations at once. A Block is made up of <code>Piece</code> objects.
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class Block implements Blockable
{
    private Piece[] cells; // either 2 or 3
    private int numCells;
    private String orientation; // "V"(vertical) or "H"(horizontal)
    private Location leftOrTopOfBlockLoc; // if horizontal block, then left cell location, otherwise top cell location
    private Color col;
    
    /**
     * Construct a Block
     * <br>precondition: <code>loc</code> valid location within the Grid
     * @param loc upper-left location of <code>numCells</code> cells
     * @param numCells number of Grid cells that this <code>Block</code> will contain
     * @param orientation "V"(vertical) or "H"(horizontal)
     * @param col color of this <code>Block</code> 
     */    
    public Block(Location loc, int numCells, String orientation, Color col)
    {
      this.orientation = orientation;
      this.numCells = numCells;
      this.col = col;
      leftOrTopOfBlockLoc = loc;
      fillCells();
    }

    /**
     * Initializes private data member with the <code>Piece</code>s that will make up
     * this <code>Block</code> and eventually be placed in the Grid
     */    
    public void fillCells() 
    {
      cells = new Piece[numCells];
      Location loc = leftOrTopOfBlockLoc; // just using a shorter identifier name
      if ( "V".equalsIgnoreCase(orientation) )  // vertical
      {
        if ( numCells + loc.getRow() > 6 ) // can't move piece - moves off end of grid
          return;
        if ( numCells == 2 ) 
        {
          cells[0] = new Piece("_arrow", 0, col, loc);
          cells[1] = new Piece("_arrow", 180, col, loc.getAdjacentLocation(180));
        }
        else
        {
          cells[0] = new Piece("_arrow", 0, col, loc);
          loc = loc.getAdjacentLocation(180);
          cells[1] = new Piece("", 0, col, loc);
          cells[2] = new Piece("_arrow", 180, col, loc.getAdjacentLocation(180));
        }
      }
      else // horizontal
      {
        if ( numCells + loc.getCol() > 6 ) // can't move piece - moves off end of grid
          return;
        if ( numCells == 2 ) 
        {
          cells[0] = new Piece("_arrow", 270, col, loc);
          cells[1] = new Piece("_arrow", 90, col, loc.getAdjacentLocation(90));
        }
        else 
        {
          cells[0] = new Piece("_arrow", 270, col, loc);
          loc = loc.getAdjacentLocation(90);
          cells[1] = new Piece("", 90, col, loc);
          cells[2] = new Piece("_arrow", 90, col, loc.getAdjacentLocation(90));
        }
      }
    }
    /**
     * Determines if a given Location lies within the bounds of this <code>Block</code>
     * <br>precondition: <code>loc</code> is a valid location within the Grid
     * @param loc valid location within the Grid
     * @return returns the location of the upper-left cell of this <code>Block</code> if
     * <code>loc</code> lies within this <code>Block</code>'s boundaries, otherwise returns null
     */    
    
    // is loc any part of the block, if so, return leftOrTopOfBlock location,
    // otherwise, return null
    public Location contains(Location loc)
    {
      for (Piece p: cells)
      if ( p.getLocation().equals(loc) )
        return leftOrTopOfBlockLoc;
      return null;
    }

    /**
     * Changes the position of this block
     * <br>precondition: <code>loc</code> is a valid location within the Grid
     * @param loc new upper-left location of this <code>Block</code> 
     */        
    public void updatePosition(Location loc)
    {
      leftOrTopOfBlockLoc = loc;
      fillCells();
    }

    /**
     * Get the <code>Piece</code>s that make up this <code>Block</code>
     * @return returns the <code>Piece</code>s that make up this <code>Block</code>
     */        
    public Piece[] getCells() 
    {
      return cells;
    }

    /**
     * Get the number of cells/Pieces that make up this <code>Block</code>
     * @return returns the number of cells/Pieces that make up this <code>Block</code>
     */        
    public int getNumCells() 
    {
      return numCells; 
    }

    /**
     * Get the location of this <code>Block</code>
     * @return returns the upper-left location of this <code>Block</code>
     */            
    public Location getLocation() 
    {
      return leftOrTopOfBlockLoc; 
    }

    /**
     * Get the color of this <code>Block</code>
     * @return returns the color of this <code>Block</code>
     */        
    public Color getColor() 
    {
      return col; 
    }

    /**
     * Returns whether this <code>Block</code> is vertical or horizontal
     * @return returns <code>true</code> if this <code>Block</code> is vertical, <code>false</code> otherwise
     */            
    public boolean isVertical() 
    { 
      return "V".equalsIgnoreCase(orientation); 
    }
    
    public String toString() 
    {
      String str = "";
      if ( "V".equalsIgnoreCase(orientation) )
        str += leftOrTopOfBlockLoc.toString() + " Vertical " + numCells + "-cell";
      else
        str += leftOrTopOfBlockLoc.toString() + " Horizontal " + numCells + "-cell";
      return str;
    }
}