/*
 * AP(r) Computer Science GridWorld Case Study:
 * Copyright(c) 2002-2006 College Entrance Examination Board 
 * (http://www.collegeboard.com).
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.world.World;

import java.awt.Color;
import java.util.ArrayList;
/**
 * The <code>MagicWandWorld</code> is the main application. 
 * <br />
 * This class is not tested on the AP CS A and AB exams.
 * <p> 
 * copyright&copy; 2007 Dave Wittry (http://apcomputerscience.com)
 * @author Dave Wittry
 */
public class MagicWandWorld extends World<Tile>
{
   private Location startingLoc = null;
   private Color startingColor = null;

   /**
     * Constructs a MagicWand World
     */      
   public MagicWandWorld()
   {
     makeWorld();
     setMessage("Your Magic Wand is now the eye dropper - \"Pick Up\" a color by clicking a cell");
   }

   /**
     * Ramdomly place Tiles in the world
     */      
   private void makeWorld()
   {
     Grid<Tile> gr = getGrid();
     Color[] colors = { Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW };
 
     for (int r = 0; r<gr.getNumRows(); r++)
       for (int c = 0; c<gr.getNumCols(); c++) 
       {
         int num = (int) (Math.random() * colors.length);
         add( new Location(r,c), new Tile("AP", colors[num]) );   
       }
   }
   
   /**
    * This is the recursive method which does the changing of the colors. It is called from locationClicked().
    * @param loc location of the candidate cell for a color change
    * @param col color of the cell at location <code>loc</code>
    */
   private void changeColors(Location loc, Color col)
   {
     // Recursive Version
     Grid<Tile> gr = getGrid();
     if ( ! gr.get(loc).getColor().equals(col) ) 
       return;
     gr.put(loc, new Tile("AP", startingColor));
     ArrayList<Location> nbrs = gr.getOccupiedAdjacentLocations(loc);
     for (Location aLoc: nbrs)
       changeColors(aLoc, col);
     // End of Recursive Version
        
        // Stack version
//         Grid<Tile> gr = getGrid();
//         if ( ! gr.get(loc).getColor().equals(col) ) 
//           return;
//         Stack<Location> locations = new Stack<Location>();
//         add(loc, new Tile("AP", startingColor));
//         locations.push(loc);
//        
//         while(!locations.isEmpty()) 
//         {
//           for(Location tempLoc: gr.getOccupiedAdjacentLocations(locations.pop()))
//           {
//             if (gr.get(tempLoc).getColor().equals(col)) 
//             {
//               add(tempLoc, new Tile("AP", startingColor));
//               locations.push(tempLoc);
//             }
//           }
//         }
        // no particular reason to choose Stack - could pick Queue, ArrayList, etc.
        // End of Stack Version
   }
   
   /**
    * This method is auto-magically called by the GUI and passed the 
    * location that the user clicked.
    * @param loc location on the Grid where the mouse was clicked
    * @return <code>true</code> if the world consumes the key press, <code>false</code>
    * @see <code>World</code> class
    */
   public boolean locationClicked(Location loc)
   {
       Grid<Tile> gr = getGrid();
       if ( startingLoc == null )
       {
         startingLoc = loc;
         startingColor = gr.get(loc).getColor();
         setMessage("You now have a magic wand, try it!\nYour magic color is " + startingColor);
       }
       else 
         if ( ! gr.get(loc).getColor().equals(startingColor) ) 
           changeColors(loc, gr.get(loc).getColor());
       return true;      
   }
    
   public static void main(String[] args)
   {
     World mw = new MagicWandWorld();
     System.setProperty("info.gridworld.gui.selection", "hide");
     mw.show();
   }
}